package gov.va.med.domain.service.messaging.environment;

import java.io.Serializable;

/**
 * DestinationKey used as holder of values to idetify the destination.  This
 * class can have either the InstituionId or the StationNumber or both depending 
 * on how it is used.  
 *
 * @author Slava Uchitel
 * @version $Id: DestinationKey.java,v 1.6 2005/07/17 11:57:57 joel.goldberg Exp $
 * @since MHV 2.0 <br>Mar 1, 2005
 */
public class DestinationKey implements Comparable, Serializable
{
    private static final long serialVersionUID = 3257289145079576369L;
    private String _stationNumber;
    private Long _institutionId;

    public DestinationKey(String stationNumber) {
        _stationNumber = stationNumber;
    }
    
    public DestinationKey(Long institutionId) {
        _institutionId = institutionId;
    }
 
    public void setInstitutionId(Long id) {
        _institutionId = id;
    }
    
    public String getStationNumber() {
        return _stationNumber;
    }
    
    public void setStationNumber(String number) {
        _stationNumber = number;
    }
    
    public Long getInstitutionId() {
        return _institutionId;
    }
    /**
     * Used by the destinationsMap (TreeMap) in NamingDirectory 
     * @throws ClassCastException if obj not a DestinationKey
     */
	public int compareTo(Object obj) throws ClassCastException {

		DestinationKey key = (DestinationKey) obj;
		//System.out.println(key.getInstitutionId() + " " + key.getStationNumber() + " " + getInstitutionId() + " " + getStationNumber());
		
		// protective code to avoid null pointer exception
		// just in case the key was not populated with Station Number
		// which can happen because of the dual valued nature of DestinationKey.
	    if (getStationNumber() == null ) {return -1;}
	    if (key.getStationNumber() == null) {return 1;}
		return getStationNumber().compareTo(key.getStationNumber());

	}
}
